import yaml, time, subprocess
from string import Template

def process_file(input_file, output_file):
    with open(input_file, 'r', encoding='utf-8') as f:
        lines = f.readlines()

    # 找到 "Frame Number" 行的位置
    start_index = None
    for i, line in enumerate(lines):
        if line.strip().startswith("Frame Number"):
            start_index = i + 1  # 下一行开始处理
            break

    if start_index is None:
        print("not found 'Frame Number'")
        return

    # 输出处理后的内容到文件
    with open(output_file, 'w', encoding='utf-8') as f_out:
        for line in lines[start_index:]:
            line = line.strip()
            if not line:  # 跳过空行
                continue
            parts = line.split('\t')
            if len(parts) < 5:  # 确保至少有时间戳和xyz列
                print("wrong line ", line)
                continue

            timestamp = parts[1]  # 第2列为时间戳
            x, y, z = parts[-3:]  # 最后三列为x, y, z
            quaternion = "0 0 0 1"  # 补齐四元数

            # 写入输出文件，格式为：timestamp x y z qx qy qz qw
            f_out.write("{timestamp} {x} {y} {z} {quaternion}\n".format(
                timestamp=timestamp, x=x, y=y, z=z, quaternion=quaternion))

    print("finish: ", output_file)

# Generate mappingtask.yaml according to template.yaml and config.yaml
config_raw = open("/slamhive/config.yaml",'r',encoding="UTF-8").read()



config_dict = yaml.load(config_raw, Loader=yaml.FullLoader)
algo_dict = config_dict["algorithm-parameters"]
datatset_dict = config_dict["dataset-parameters"]
general_dict = config_dict["general-parameter"]
all_dict = {}
for key, value in algo_dict.items():
    all_dict.update({key: value})
for key, value in datatset_dict.items():
    all_dict.update({key: value})
# change fps
# all_dict['-fps'] = str(int(float(all_dict['fps'])))

dataset_name = config_dict['slam-hive-dataset']
dataset_path = "/slamhive/dataset/EuRoCMAV/machine_hall/MH_01_easy/MH_01_easy.slam"
# dataset name
if dataset_name == "slambench_MH_01_easy":
    dataset_path = "/slamhive/dataset/EuRoCMAV/machine_hall/MH_01_easy/MH_01_easy.slam"
# 组成脚本文件
slambench_command = "/home/slambench3/build/bin/benchmark_loader -i " + dataset_path + " -load /home/slambench3/build/lib/liborbslam2-original-library.so"
for key, value in all_dict.items():
    slambench_command += " " + str(key) + " " + str(value)
slambench_command += " -o " + "/slamhive/result/origin.txt"
print(slambench_command)
subprocess.run("bash -c ' cd /home/slambench3 ; "+ slambench_command +"'", shell=True)
# 然后转换成traj.txt轨迹文件
process_file("/slamhive/result/origin.txt", "/slamhive/result/traj.txt") 

subprocess.run("bash -c 'touch /slamhive/result/finished ;'", shell=True)
